#include <stdio.h>
#include <windows.h>
#include "resource.h"
#include <miracl.h>
#include "blowfish.c"
#include "md5.c"

extern long B64encode(long,long,long);

HINSTANCE	hInst;

BOOL CALLBACK DialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{	

	unsigned char szName[600] = {0};
	unsigned char szSerial[600] = {0};
	unsigned char szHash[17] = {0};
	long dtBlowfishKey[2] = {0x21320D0A,0x7F705211};
	long dtA,dtB;
	long dtLength,i,dtSerialCount;
	big b1,b2,b3,b4,b5,bmd5;
	big bigmods[2],bigrems[2];
	big_chinese pbc;
	miracl *mip=mirsys(100,0);
	BLOWFISH_CTX blowfishctx;
	MD5_CTX md5context;

	switch (message)
	{    
	case WM_CLOSE:
		EndDialog(hWnd,0);
		break;
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{ 
		case IDC_GENERATE:
			memset(szName,0,600);
			dtLength=GetDlgItemText(hWnd, IDC_EDITNAME, szName, 100);

			if (dtLength%8 != 0) { dtLength=dtLength+(8-dtLength%8); }

			//encrypt name
			Blowfish_Init(&blowfishctx, &dtBlowfishKey, 8);

			for (i=0;i<dtLength;i+=8) {
				__asm{
					lea esi,szName
					add	esi,i
					mov eax,dword ptr [esi]
					mov	dtA,eax
					mov eax,dword ptr [esi+4]
					mov	dtB,eax
				}
				Blowfish_Encrypt(&blowfishctx, &dtA, &dtB);
				__asm{
					lea esi,szName
					add	esi,i
					mov eax,dtA
					mov dword ptr [esi],eax
					mov eax,dtB
					mov dword ptr [esi+4],eax
				}
			}

			//write bignum1
			dtSerialCount=dtLength+1;
			__asm{
				lea edi,szSerial
				mov	eax,dtLength
				mov byte ptr [edi],al
			}
			for (i=0;i<dtLength;i++) {
				szSerial[i+1]=szName[i];
			}

			//hashes bignum1
			MD5Init(&md5context);
			MD5Update(&md5context,&szName,dtLength);
			MD5Final(&szHash,&md5context);

			mip->IOBASE=16;
			b1=mirvar(0);
			b2=mirvar(0);
			b3=mirvar(0);
			b4=mirvar(0);
			b5=mirvar(0);
			bmd5=mirvar(0);
			bigmods[0]=mirvar(0);
			bigmods[1]=mirvar(0);
			bigrems[0]=mirvar(0);
			bigrems[1]=mirvar(0);

			bytes_to_big(dtLength,&szName,b1);
			bytes_to_big(16,&szHash,bmd5);

			// b2=md5^2-1
			// b3=md5^2+1
			power(bmd5,2,b2,b2);
			copy(b2,b3);
			decr(b2,1,b2);
			incr(b3,1,b3);

			if (compare(b1,bmd5)==0) { incr(b4,2,b4); }
			else {
				power(bmd5,3,bmd5,bmd5);
				power(b1,3,b1,b1);
				subtract(b1,bmd5,b4);
				absol(b4,b4);
			}

			cinstr(bigmods[0],"CFF85F42917FA33F");
			cinstr(bigmods[1],"A7FB01F8D55C5C6B");

			//put md5hash.dtC and md5hash.dtA in bignums
			__asm{
				lea edi,szHash
				mov eax,dword ptr [edi]
				mov dtA,eax
				mov eax,dword ptr [edi+8]
				mov dtB,eax
			}
			bytes_to_big(4,&dtA,bigrems[0]);
			bytes_to_big(4,&dtB,bigrems[1]);

			//apply chinese remainder
			crt_init(&pbc,2,&bigmods);
			crt(&pbc,&bigrems,b5);
			crt_end(&pbc);

			//write all bignumbers
			dtLength=big_to_bytes(0,b2,&szName);
			__asm{
				lea edi,szSerial
				add	edi,dtSerialCount
				mov eax,dtLength
				mov byte ptr [edi],al
			}
			for (i=0;i<dtLength;i++) {
				szSerial[dtSerialCount+1+i]=szName[i];
			}
			dtSerialCount+=dtLength+1;
						dtLength=big_to_bytes(0,b3,&szName);
			__asm{
				lea edi,szSerial
				add	edi,dtSerialCount
				mov eax,dtLength
				mov byte ptr [edi],al
			}
			for (i=0;i<dtLength;i++) {
				szSerial[dtSerialCount+1+i]=szName[i];
			}
			dtSerialCount+=dtLength+1;
			dtLength=big_to_bytes(0,b4,&szName);
			__asm{
				lea edi,szSerial
				add	edi,dtSerialCount
				mov eax,dtLength
				mov byte ptr [edi],al
			}
			for (i=0;i<dtLength;i++) {
				szSerial[dtSerialCount+1+i]=szName[i];
			}
			dtSerialCount+=dtLength+1;
			dtLength=big_to_bytes(0,b5,&szName);
			__asm{
				lea edi,szSerial
				add	edi,dtSerialCount
				mov eax,dtLength
				mov byte ptr [edi],al
			}
			for (i=0;i<dtLength;i++) {
				szSerial[dtSerialCount+1+i]=szName[i];
			}
			dtSerialCount+=dtLength+1;

			//add lastbyte (050h)
			__asm{
				lea edi,szSerial
				add edi,dtSerialCount
				mov byte ptr [edi],0x50
			}
			dtSerialCount++;

			//encode in base64
			B64encode(&szName,&szSerial,dtSerialCount);

			mirkill(b1);
			mirkill(b2);
			mirkill(b3);
			mirkill(b4);
			mirkill(b5);
			mirkill(bmd5);
			mirkill(bigmods[0]);
			mirkill(bigmods[1]);
			mirkill(bigrems[0]);
			mirkill(bigrems[1]);
			mirexit();

			SetDlgItemText(hWnd, IDC_EDITSERIAL, szName);
			break;
		case IDC_ABOUT:
			MessageBox(hWnd, "keygenerator for rascal' s keygenme 1\nprotection: md5, blowfish and bignums", "about", MB_OK);
			break;
		}
		break;
	case WM_INITDIALOG:
		SendMessageA(hWnd,WM_SETICON,(WPARAM) 1,(LPARAM) LoadIconA(hInst,MAKEINTRESOURCE(IDI_ICON)));
		break;
	}
     return 0;
}

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	hInst=hInstance;
	DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_DIALOG1), NULL, (DLGPROC)DialogProc,0);
	return 0;
}
