.data
dtOpcode0		dd	offset szOp0_Add
			dd	offset szOp0_Sub
			dd	offset szOp0_Imul
			dd	offset szOp0_Idiv
			dd	offset szOp0_Iquo
			dd	offset szOp0_And
			dd	offset szOp0_Or
			dd	offset szOp0_Xor
			dd	offset szOp0_IsNull
			dd	offset szOp0_Neg
			dd	offset szOp0_Inc
			dd	offset szOp0_Dec
dtOpcode1		dd	offset szOp1_Rol
			dd	offset szOp1_Ror
			dd	offset szOp1_Shl
			dd	offset szOp1_Shr
dtOpcode3		dd	offset szOp3_Jmp
			dd	offset szOp3_Jnz
			dd	offset szOp3_Jz
			dd	offset szOp3_Jg
			dd	offset szOp3_Jl
			dd	offset szOp3_Jnz
			dd	offset szOp3_Jz
dtOpcode4		dd	offset szOp4_Push
			dd	offset szOp4_Pop
dtOpcode5		dd	offset szOp5_0
			dd	offset szOp5_1
			dd	offset szOp5_2
			dd	offset szOp5_3
			dd	offset szOp5_4
			dd	offset szOp5_5
dtOpcode6		dd	offset szOp6_CallPush
			dd	offset szOp6_RetPop
			dd	offset szOp6_Get
			dd	offset szOp6_Set
dtOpcode6_dword		dd	offset szOp6_Mem
			dd	offset szOp6_Char
			dd	offset szOp6_MouseX
			dd	offset szOp6_MouseY
			dd	offset szOp6_Repaint
			dd	offset szOp6_Counter
dtFlow			dd	offset szFlow_Wait
			dd	offset szFlow_Halt
szOp0_Add		db	'add',0
szOp0_Sub		db	'sub',0
szOp0_Imul		db	'imul',0
szOp0_Idiv		db	'idiv',0
szOp0_Iquo		db	'iquo',0
szOp0_And		db	'and',0
szOp0_Or		db	'or',0
szOp0_Xor		db	'xor',0
szOp0_IsNull		db	'isnull',0
szOp0_Neg		db	'neg',0
szOp0_Inc		db	'inc',0
szOp0_Dec		db	'dec',0
szOp1_Rol		db	'rol',0
szOp1_Ror		db	'ror',0
szOp1_Shl		db	'shl',0
szOp1_Shr		db	'shr',0
szOp2_Mov		db	'mov',0
szOp3_Jmp		db	'jmp',0
szOp3_Jnz		db	'jnz',0
szOp3_Jz		db	'jz',0
szOp3_Jg		db	'jg',0
szOp3_Jl		db	'jl',0
szBreak			db	' -----------------------------------------------------------------',0
szCmp			db	'cmp',0
szCommaNull		db	', 0',0
szOp4_Push		db	'push',0
szOp4_Pop		db	'pop',0
IF (bHTMLOUTPUT)
	szOp5_0			db	'[<SPAN CLASS=w>!</SPAN>] OP2S=DATA',0	; operand2 shift (for IOpCode)
	szOp5_1			db	'[<SPAN CLASS=w>!</SPAN>] OP2S=VIDEO',0
	szOp5_2			db	'[<SPAN CLASS=w>!</SPAN>] OP2S=10b',0
	szOp5_3			db	'[<SPAN CLASS=w>!</SPAN>] OP1S=DATA',0	; operand1 shift (for IOpCode)
	szOp5_4			db	'[<SPAN CLASS=w>!</SPAN>] OP1S=VIDEO',0
	szOp5_5			db	'[<SPAN CLASS=w>!</SPAN>] OP1S=10b',0
	szFlow_Wait		db	'[<SPAN CLASS=w>!</SPAN>] WAIT WINDOWS MESSAGE',0
	szFlow_Halt		db	'[<SPAN CLASS=w>!</SPAN>] HALT',0
ELSE
	szOp5_0			db	'[!] OP2S=DATA',0	; operand2 shift (for IOpCode)
	szOp5_1			db	'[!] OP2S=VIDEO',0
	szOp5_2			db	'[!] OP2S=10b',0
	szOp5_3			db	'[!] OP1S=DATA',0	; operand1 shift (for IOpCode)
	szOp5_4			db	'[!] OP1S=VIDEO',0
	szOp5_5			db	'[!] OP1S=10b',0
	szFlow_Wait		db	'[!] WAIT WINDOWS MESSAGE',0
	szFlow_Halt		db	'[!] HALT',0
ENDIF
szOp6_CallPush		db	'callp',0
szOp6_RetPop		db	'retp',0
szOp6_Get		db	'get',0
szOp6_Set		db	'set',0
szOp6_Mem		db	'MemPointer',0
szOp6_Char		db	'Char',0
szOp6_MouseX		db	'MouseX',0
szOp6_MouseY		db	'MouseY',0
szOp6_Repaint		db	'RepaintControls',0
szOp6_Counter		db	'InstructionCounter',0

bfOp1d			db	50 dup (0)
bfOp2d			db	50 dup (0)
bfOp2b			db	50 dup (0)

szImm			db	'0%Xh',0
szImmd			db	'%d',0
szdReg			db	'reg_%d',0
szbReg			db	'reg_%d (byte)',0
szdMem			db	'[mem_%X]',0
szbMem			db	'[mem_%X] (byte)',0
szddReg			db	'[d@[reg_%X]]',0
szbdReg			db	'[d@[reg_%X]] (byte)',0
szComma			db	', ',0
szOP1S			db	'OP1S.',0
szOP2S			db	'OP2S.',0

.code

			mov	al,(OP ptr [esi]).bFlags
			.IF (al & fIMM)
				; memory operands
				mov	al,(OP ptr [esi]).dtImmInfo
				and	al,3 ; inst1
				mov	ebx,(OP ptr [esi]).Op1
				.IF (al==0)
					shr	ebx,2
					sub	ebx,2
					invoke	wsprintfA,addr bfOp1d,addr szdReg,ebx
				.ELSEIF (al==1)
					invoke	lstrcpy,addr bfOp1d,addr szOP1S
					invoke	wsprintfA,addr bfFormat,addr szdMem,ebx
					invoke	lstrcat,addr bfOp1d,addr bfFormat
				.ELSEIF (al==3)
					invoke	lstrcpy,addr bfOp1d,addr szOP1S
					shr	ebx,2
					sub	ebx,2
					invoke	wsprintfA,addr bfFormat,addr szddReg,ebx
					invoke	lstrcat,addr bfOp1d,addr bfFormat
				.ENDIF
				mov	al,(OP ptr [esi]).dtImmInfo
				shr	al,2 ; inst2
				mov	ebx,(OP ptr [esi]).Op2
				.IF (al==0)
					shr	ebx,2
					sub	ebx,2
					invoke	wsprintfA,addr bfOp2d,addr szdReg,ebx
					invoke	wsprintfA,addr bfOp2b,addr szbReg,ebx
				.ELSEIF (al==1)
					invoke	lstrcpy,addr bfOp2d,addr szOP2S
					invoke	lstrcpy,addr bfOp2b,addr szOP2S
					invoke	wsprintfA,addr bfFormat,addr szdMem,ebx
					invoke	lstrcat,addr bfOp2d,addr bfFormat
					invoke	wsprintfA,addr bfFormat,addr szbMem,ebx
					invoke	lstrcat,addr bfOp2b,addr bfFormat
				.ELSEIF (al==2)
					.IF (ebx<0ah)
						invoke	wsprintfA,addr bfOp2d,addr szImmd,ebx
					.ELSE
						invoke	wsprintfA,addr bfOp2d,addr szImm,ebx
					.ENDIF
					invoke	lstrcpy,addr bfOp2b,addr bfOp2d
				.ELSEIF (al==3)
					invoke	lstrcpy,addr bfOp2d,addr szOP2S
					invoke	lstrcpy,addr bfOp2b,addr szOP2S
					shr	ebx,2
					sub	ebx,2
					invoke	wsprintfA,addr bfFormat,addr szddReg,ebx
					invoke	lstrcat,addr bfOp2d,addr bfFormat
					invoke	wsprintfA,addr bfFormat,addr szbdReg,ebx
					invoke	lstrcat,addr bfOp2b,addr bfFormat
				.ENDIF

			.ELSE
				; registers operands
				mov	ebx,(OP ptr [esi]).Op1
				shr	ebx,2
				sub	ebx,2
				invoke	wsprintfA,addr bfOp1d,addr szdReg,ebx
				mov	ebx,(OP ptr [esi]).Op2
				shr	ebx,2
				sub	ebx,2
				invoke	wsprintfA,addr bfOp2d,addr szdReg,ebx
				invoke	wsprintfA,addr bfOp2b,addr szbReg,ebx
			.ENDIF

			mov	al,(OP ptr [esi]).OpGroup

			.IF (al==0)
				movzx	ebx,(OP ptr [esi]).OpCode
				mov	eax,[dtOpcode0+ebx*4]
				invoke	lstrcat,addr bfAsm,eax
				invoke	lstrcat,addr bfAsm,addr szTab
				invoke	lstrcat,addr bfAsm,addr bfOp1d
				.IF (bl<=8)
					invoke	lstrcat,addr bfAsm,addr szComma
					invoke	lstrcat,addr bfAsm,addr bfOp2d
				.ENDIF

			.ELSEIF (al==1)
				movzx	ebx,(OP ptr [esi]).OpCode
				mov	eax,[dtOpcode1+ebx*4]
				invoke	lstrcat,addr bfAsm,eax
				invoke	lstrcat,addr bfAsm,addr szTab
				invoke	lstrcat,addr bfAsm,addr bfOp1d
				invoke	lstrcat,addr bfAsm,addr szComma
				invoke	lstrcat,addr bfAsm,addr bfOp2b

			.ELSEIF (al==2)
				invoke	lstrcat,addr bfAsm,addr szOp2_Mov
				invoke	lstrcat,addr bfAsm,addr szTab
				invoke	lstrcat,addr bfAsm,addr bfOp1d
				invoke	lstrcat,addr bfAsm,addr szComma
				invoke	lstrcat,addr bfAsm,addr bfOp2d

			.ELSEIF (al==3)
				movzx	ebx,(OP ptr [esi]).OpCode
				.IF (bl>=1)
					invoke	lstrcat,addr bfAsm,addr szCmp
					invoke	lstrcat,addr bfAsm,addr szTab
					invoke	lstrcat,addr bfAsm,addr bfOp1d
					.IF (bl<=4)
						invoke	lstrcat,addr bfAsm,addr szComma
						invoke	lstrcat,addr bfAsm,addr bfOp2d
					.ELSE
						invoke	lstrcat,addr bfAsm,addr szCommaNull
					.ENDIF
					invoke	lstrcat,addr bfAsm,addr szCRLF
					invoke	lstrcat,addr bfAsm,addr bfAddress
					invoke	lstrcat,addr bfAsm,addr szTabs
				.ENDIF
				mov	eax,[dtOpcode3+ebx*4]
				invoke	lstrcat,addr bfAsm,eax
				invoke	lstrcat,addr bfAsm,addr szTab
				mov	eax,(OP ptr [esi]).Op3
				IF (bHTMLOUTPUT)
					invoke	wsprintfA,addr bfFormat,addr szLoc,eax,eax
				ELSE
					invoke	wsprintfA,addr bfFormat,addr szLoc,eax
				ENDIF
				invoke	lstrcat,addr bfAsm,addr bfFormat
				.IF (bl==0)
					invoke	lstrcat,addr bfAsm,addr szCRLF
					invoke	lstrcat,addr bfAsm,addr bfAddress
					invoke	lstrcat,addr bfAsm,addr szBreak
				.ENDIF

			.ELSEIF (al==4)
				movzx	ebx,(OP ptr [esi]).OpCode
				mov	eax,[dtOpcode4+ebx*4]
				invoke	lstrcat,addr bfAsm,eax
				invoke	lstrcat,addr bfAsm,addr szTab
				.IF (bl==0)
					mov	eax,offset bfOp2d
				.ELSE
					mov	eax,offset bfOp1d
				.ENDIF
				invoke	lstrcat,addr bfAsm,eax

			.ELSEIF (al==5)
				movzx	ebx,(OP ptr [esi]).OpCode
				mov	eax,[dtOpcode5+ebx*4]
				invoke	lstrcat,addr bfAsm,eax

			.ELSEIF (al==6)
				movzx	ebx,(OP ptr [esi]).OpCode
				mov	eax,[dtOpcode6+ebx*4]
				invoke	lstrcat,addr bfAsm,eax
				.IF (bl==0)
					invoke	lstrcat,addr bfAsm,addr szTab
					mov	eax,(OP ptr [esi]).Op3
					IF (bHTMLOUTPUT)
						invoke	wsprintfA,addr bfFormat,addr szSub,eax,eax
					ELSE
						invoke	wsprintfA,addr bfFormat,addr szSub,eax
					ENDIF
					invoke	lstrcat,addr bfAsm,addr bfFormat
				.ELSEIF (bl==1)
					invoke	lstrcat,addr bfAsm,addr szCRLF
					invoke	lstrcat,addr bfAsm,addr bfAddress
					invoke	wsprintfA,addr bfFormat,addr szSubEndFormat,dtCurrentSub
					invoke	lstrcat,addr bfAsm,addr bfFormat
					invoke	lstrcat,addr bfAsm,addr szCRLF
					invoke	lstrcat,addr bfAsm,addr bfAddress
					invoke	lstrcat,addr bfAsm,addr szBreak
				.ELSEIF (bl==2)
					invoke	lstrcat,addr bfAsm,addr szTab
					invoke	lstrcat,addr bfAsm,addr bfOp1d
					invoke	lstrcat,addr bfAsm,addr szComma
					mov	eax,(OP ptr [esi]).Op2
					mov	eax,[dtOpcode6_dword+eax*4]
					invoke	lstrcat,addr bfAsm,eax
				.ELSEIF (bl==3)
					invoke	lstrcat,addr bfAsm,addr szTab
					mov	eax,(OP ptr [esi]).Op2
					mov	eax,[dtOpcode6_dword+eax*4]
					invoke	lstrcat,addr bfAsm,eax
					invoke	lstrcat,addr bfAsm,addr szComma
					invoke	lstrcat,addr bfAsm,addr bfOp1d
				.ENDIF

			.ELSEIF (al==15)
				movzx	ebx,(OP ptr [esi]).OpCode
				mov	eax,[dtFlow+ebx*4]
				invoke	lstrcat,addr bfAsm,eax
				.IF (bl==1)
					invoke	lstrcat,addr bfAsm,addr szCRLF
					invoke	lstrcat,addr bfAsm,addr bfAddress
					invoke	lstrcat,addr bfAsm,addr szBreak
				.ENDIF
			.ENDIF
