;:::::::::::::::::::::::::::::::::::::: B i g C r e a t e :::::::::::::::::::::::::::::::::::::::
; dtValue: initial value of the bignum
; returns a pointer to a bignum

_BigCreate		proc	uses ecx edi esi,dtValue:dword

			_BIGM_MEMALLOC _BIG_BIGSIZE*4

			mov	ecx,dtValue
			test	ecx,ecx
			jz	__ret

			mov	dword ptr [eax],1
			mov	dword ptr [eax+4],ecx

__ret:			ret

_BigCreate		endp

;::::::::::::::::::::::::::::::::::::: B i g D e s t r o y ::::::::::::::::::::::::::::::::::::::
; pBig: pointer to bignum (returned by _BigCreate)
; returns zero if fails

_BigDestroy		proc	uses ecx edi esi,pBig:dword

			_BIGM_MEMDEALLOC pBig

			ret

_BigDestroy		endp

;:::::::::::::::::::::::::::::::::::::::: B i g C o p y :::::::::::::::::::::::::::::::::::::::::
; pBig1: pointer to source bignum
; pBig2: pointer to destination bignum

_BigCopy		proc	uses ecx edi esi,pBig1:dword,pBig2:dword

			mov	esi,pBig1
			cmp	esi,pBig2
			jz	__ret

			_BIGM_BIGCLEAR pBig2

			mov	edi,pBig2
			mov	ecx,dword ptr [esi]
			mov	dword ptr [edi],ecx
			add	edi,4
			add	esi,4
			rep	movsd

__ret:			ret

_BigCopy		endp

;::::::::::::::::::::::::::::::::::::: B i g C o m p a r e ::::::::::::::::::::::::::::::::::::::
; returns -1 if Big1<Big2
;	  0  if Big1=Big2
;	  1  if Big1>Big2

_BigCompare		proc	uses ebx ecx edi esi,pBig1:dword,pBig2:dword

			mov	esi,pBig1
			mov	edi,pBig2

			cmp	esi,edi
			jz	__null

			mov	ecx,dword ptr [esi]
			cmp	ecx,dword ptr [edi]
			jb	__less
			ja	__plus

			test	ecx,ecx
			jz	__null

			mov	ebx,ecx
			shl	ebx,2
			add	edi,ebx
			add	esi,ebx

			std
			repz	cmpsd
			cld
			ja	__plus
			jz	__null

__less:			xor	eax,eax
			dec	eax
			ret

__null:			xor	eax,eax
			ret

__plus:			xor	eax,eax
			inc	eax
			ret

_BigCompare		endp

;::::::::::::::::::::::::::::::::::: B i g C o m p a r e 3 2 ::::::::::::::::::::::::::::::::::::
; returns -1 if Big<dtValue
;	  0  if Big=dtValue
;	  1  if Big>dtValue

_BigCompare32		proc	uses ecx edi esi,pBig:dword,dtValue:dword

			mov	esi,pBig
			mov	ecx,dword ptr [esi]

			cmp	ecx,1
			ja	__plus

			mov	ecx,dword ptr [esi+4]

			cmp	ecx,dtValue
			jz	__null
			ja	__plus

__less:			xor	eax,eax
			dec	eax
			ret

__null:			xor	eax,eax
			ret

__plus:			xor	eax,eax
			inc	eax
			ret

_BigCompare32		endp
