;:::::::::::::::::::::::::::::::::::: B i g P o w M o d 3 2 :::::::::::::::::::::::::::::::::::::
; (big)z = (big)x ^ (dword)dte mod (big)n
; returns 0 if no error, -1 if division by zero
; coded-like-a-pig

_BigPowMod32		proc	uses ebx ecx edi esi,pBigx:dword,dte:dword,pBign:dword,pBigz:dword

			mov	ebx,pBign
			cmp	dword ptr [ebx],0
			jz	__divisionbyzero

			invoke	_BigCreate,1
			mov	edi,eax

			mov	ecx,dte
			test	ecx,ecx
			jz	__done

			ALIGN	4
__loop:			invoke	_BigMul,edi,edi,edi
			invoke	_BigMod,edi,ebx,edi

			shl	ecx,1
			jnc	__nobit

			invoke	_BigMul,edi,pBigx,edi
			invoke	_BigMod,edi,ebx,edi

__nobit:		test	ecx,ecx
			jnz	__loop

__done:			invoke	_BigCopy,edi,pBigz
			invoke	_BigDestroy,edi

			xor	eax,eax
			ret

__divisionbyzero:	mov	eax,-1
			ret

_BigPowMod32		endp

;:::::::::::::::::::::::::::::::::::::: B i g P o w M o d :::::::::::::::::::::::::::::::::::::::
; (big)z = (big)x ^ (big)y mod (big)n
; returns 0 if no error, -1 if division by zero
; coded-like-a-pig

_BigPowMod		proc	uses ebx ecx edi esi,pBigx:dword,pBigy:dword,pBign:dword,pBigz:dword

			mov	ebx,pBign
			cmp	dword ptr [ebx],0
			jz	__divisionbyzero

			invoke	_BigCreate,1
			mov	edi,eax

			mov	esi,pBigy
			mov	ecx,dword ptr [esi]
			test	ecx,ecx
			jz	__done

			shl	ecx,5
			dec	ecx

			ALIGN	4
__loop:			invoke	_BigMul,edi,edi,edi
			invoke	_BigMod,edi,ebx,edi

			bt	dword ptr [esi+4],ecx
			jnc	__nobit

			invoke	_BigMul,edi,pBigx,edi
			invoke	_BigMod,edi,ebx,edi

__nobit:		dec	ecx
			jns	__loop

__done:			invoke	_BigCopy,edi,pBigz
			invoke	_BigDestroy,edi

			xor	eax,eax
			ret

__divisionbyzero:	mov	eax,-1
			ret

_BigPowMod		endp
