;::::::::::::::::::::::::::::::::::::::::: B i g M o d ::::::::::::::::::::::::::::::::::::::::::
; BigMod
; (big)r = (big)x mod (big)y
; returns 0 if no error, -1 if division by zero
; coded-like-a-pig

_BigMod			proc	uses ebx ecx edi esi,pBigx:dword,pBigy:dword,pBigz:dword
			local	pBigSwapz:dword

			mov	edi,pBigy
			mov	ebx,dword ptr [edi]

			; check division by zero
			test	ebx,ebx
			jz	__divisionbyzero

			mov	esi,pBigx
			mov	ecx,dword ptr [esi]

			; check easy cases
			test	ecx,ecx
			jz	__null

			invoke	_BigCompare,pBigx,pBigy
			jl	__greater
			jz	__null

			invoke	_BigCreate,0
			mov	pBigSwapz,eax

			shl	ecx,5
			dec	ecx

			mov	edi,pBigSwapz
			mov	dword ptr [edi],1

			; search for first set bit
			ALIGN	4
__search:		bt	dword ptr [esi+4],ecx
			jc	__modloop
			dec	ecx
			jmp	__search

			; perform modulo reduction
__modloop:

; invoke _BigShl,edi,edi
; uses ebx,edx
;_BigShl_________________________________________________________________________
			mov	edx,dword ptr [edi]
			lea	ebx,[edi+4]
			clc
			ALIGN	4
__BShl_loop:		rcl	dword ptr [ebx],1
			lea	ebx,[ebx+4]
			dec	edx
			jnz	__BShl_loop
			jnc	__testbit
			inc	dword ptr [ebx]
			inc	dword ptr [edi]
;

__testbit:		bt	dword ptr [esi+4],ecx
			setc	al
			or	byte ptr [edi+4],al

; invoke _BigCompare,edi,pBigy
; jl	__less
; uses ebx edx
;_BigCompare_____________________________________________________________________
			mov	edx,pBigy
			mov	ebx,dword ptr [edx]
			cmp	dword ptr [edi],ebx
			jb	__less
			ja	__sub

			push	ecx
			mov	ecx,dword ptr [edi]
			lea	ebx,[ecx*4]
			add	edi,ebx
			mov	esi,edx
			add	esi,ebx
			std
			repz	cmpsd
			cld
			pop	ecx
			mov	esi,pBigx
			mov	edi,pBigSwapz
			ja	__less
;

__sub:
; invoke _BigSub,edi,pBigy,edi
; uses ebx edx
;_BigSub_________________________________________________________________________
			push	ecx
			mov	esi,pBigy
			mov	ebx,dword ptr [edi]
			mov	ecx,dword ptr [esi]
			sub	ebx,ecx
			add	esi,4
			add	edi,4

			clc
			ALIGN	4
__BSub_subloop:		mov	edx,dword ptr [esi]
			sbb	dword ptr [edi],edx
			lea	esi,[esi+4]
			lea	edi,[edi+4]
			dec	ecx
			jnz	__BSub_subloop

			jnc	__BSub_doresize

			ALIGN	4
__BSub_subcarry:	sbb	dword ptr [edi],0
			lea	edi,[edi+4]
			dec	ebx
			jc	__BSub_subcarry

__BSub_doresize:	mov	esi,pBigSwapz
			ALIGN	4
__BSub_resize:		cmp	dword ptr [edi-4],0
			jnz	__BSub_done
			dec	dword ptr [esi]
			jz	__BSub_makesize
			sub	edi,4
			jmp	__BSub_resize

__BSub_makesize:	inc	dword ptr [esi]

__BSub_done:		pop	ecx
			mov	esi,pBigx
			mov	edi,pBigSwapz
;

__less:			dec	ecx
			jns	__modloop

			invoke	_BigCopy,pBigSwapz,pBigz
			invoke	_BigDestroy,pBigSwapz

			xor	eax,eax
			ret

			; (big)y = 0
__divisionbyzero:	mov	eax,-1
			ret

			; (big)x = 0 or (big)x = (big)y
__null:			_BIGM_BIGCLEAR pBigz
			xor	eax,eax
			ret

			; (big)x < (big)y
__greater:		invoke	_BigCopy,pBigx,pBigz
			xor	eax,eax
			ret

_BigMod			endp
